/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.unsafe.reflect;

import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.commons.throwable.Try;
import io.gitlab.jfronny.commons.unsafe.reflect.LambdaFactory;
import io.gitlab.jfronny.commons.unsafe.reflect.impl.CoreReflect;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class Reflect {
    private static final MethodHandle accessibleSetter = (MethodHandle)Try.orThrow(() -> CoreReflect.lookup(AccessibleObject.class).findSetter(AccessibleObject.class, "override", Boolean.TYPE));

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = Reflect.getMethod(clazz, true, name, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(StringFormatter.methodToString(clazz, (String)name, (Class[])parameterTypes));
        }
        return method;
    }

    @Nullable
    private static Method getMethod(Class<?> clazz, boolean withPrivate, String name, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        block0: for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name) || method.getParameterCount() != parameterTypes.length) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (!method.getParameterTypes()[i].isAssignableFrom(parameterTypes[i])) continue block0;
            }
            if (!withPrivate && Modifier.isPrivate(method.getModifiers())) continue;
            return method;
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            Method method = Reflect.getMethod(genericDeclaration, false, name, parameterTypes);
            if (method == null) continue;
            return method;
        }
        return Reflect.getMethod(clazz.getSuperclass(), false, name, parameterTypes);
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return CoreReflect.getDeclaredFields(clazz);
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        return CoreReflect.getDeclaredField(clazz, name);
    }

    public static <TOut> Supplier<TOut> constructor(Class<TOut> toConstruct) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(toConstruct);
        return LambdaFactory.supplier(lookup, lookup.unreflectConstructor(toConstruct.getDeclaredConstructor(new Class[0])), toConstruct);
    }

    public static <TOut> Supplier<TOut> constructor(String targetClassName) throws Throwable {
        return Reflect.constructor(Class.forName(targetClassName));
    }

    public static <TIn, TOut> Function<TIn, TOut> constructor(Class<TOut> toConstruct, Class<TIn> parameterType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(toConstruct);
        return LambdaFactory.function(lookup, lookup.unreflectConstructor(toConstruct.getDeclaredConstructor(parameterType)), toConstruct, Reflect.mapLambdaParameter(parameterType));
    }

    public static <TIn, TOut> Function<TIn, TOut> constructor(String targetClassName, Class<TIn> parameterType) throws Throwable {
        return Reflect.constructor(Class.forName(targetClassName), parameterType);
    }

    public static <TIn1, TIn2, TOut> BiFunction<TIn1, TIn2, TOut> constructor(Class<TOut> toConstruct, Class<TIn1> parameterType1, Class<TIn2> parameterType2) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(toConstruct);
        return LambdaFactory.function(lookup, lookup.unreflectConstructor(toConstruct.getDeclaredConstructor(parameterType1, parameterType2)), toConstruct, Reflect.mapLambdaParameter(parameterType1), Reflect.mapLambdaParameter(parameterType2));
    }

    public static <TIn1, TIn2, TOut> BiFunction<TIn1, TIn2, TOut> constructor(String targetClassName, Class<TIn1> parameterType1, Class<TIn2> parameterType2) throws Throwable {
        return Reflect.constructor(Class.forName(targetClassName), parameterType1, parameterType2);
    }

    public static Runnable staticProcedure(Class<?> targetClass, String name) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.runnable(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, new Class[0])));
    }

    public static Runnable staticProcedure(String targetClassName, String name) throws Throwable {
        return Reflect.staticProcedure(Class.forName(targetClassName), name);
    }

    public static <TIn> Consumer<TIn> staticProcedure(Class<?> targetClass, String name, Class<TIn> parameterType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.consumer(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, parameterType)), Reflect.mapLambdaParameter(parameterType));
    }

    public static <TIn> Consumer<TIn> staticProcedure(String targetClassName, String name, Class<TIn> parameterType) throws Throwable {
        return Reflect.staticProcedure(Class.forName(targetClassName), name, parameterType);
    }

    public static <TIn1, TIn2> BiConsumer<TIn1, TIn2> staticProcedure(Class<?> targetClass, String name, Class<TIn1> parameterType1, Class<TIn2> parameterType2) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.consumer(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, parameterType1, parameterType2)), Reflect.mapLambdaParameter(parameterType1), Reflect.mapLambdaParameter(parameterType2));
    }

    public static <TIn1, TIn2> BiConsumer<TIn1, TIn2> staticProcedure(String targetClassName, String name, Class<TIn1> parameterType1, Class<TIn2> parameterType2) throws Throwable {
        return Reflect.staticProcedure(Class.forName(targetClassName), name, parameterType1, parameterType2);
    }

    public static <TOut> Supplier<TOut> staticFunction(Class<?> targetClass, String name, Class<TOut> returnType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.supplier(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, new Class[0])), returnType);
    }

    public static <TOut> Supplier<TOut> staticFunction(String targetClassName, String name, Class<TOut> returnType) throws Throwable {
        return Reflect.staticFunction(Class.forName(targetClassName), name, returnType);
    }

    public static <TIn, TOut> Function<TIn, TOut> staticFunction(Class<?> targetClass, String name, Class<TOut> returnType, Class<TIn> parameterType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.function(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, parameterType)), returnType, Reflect.mapLambdaParameter(parameterType));
    }

    public static <TIn, TOut> Function<TIn, TOut> staticFunction(String targetClassName, String name, Class<TOut> returnType, Class<TIn> parameterType) throws Throwable {
        return Reflect.staticFunction(Class.forName(targetClassName), name, returnType, parameterType);
    }

    public static <TIn1, TIn2, TOut> BiFunction<TIn1, TIn2, TOut> staticFunction(Class<?> targetClass, String name, Class<TOut> returnType, Class<TIn1> parameterType1, Class<TIn2> parameterType2) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.function(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, parameterType1, parameterType2)), returnType, Reflect.mapLambdaParameter(parameterType1), Reflect.mapLambdaParameter(parameterType2));
    }

    public static <TIn1, TIn2, TOut> BiFunction<TIn1, TIn2, TOut> staticFunction(String targetClassName, String name, Class<TOut> returnType, Class<TIn1> parameterType1, Class<TIn2> parameterType2) throws Throwable {
        return Reflect.staticFunction(Class.forName(targetClassName), name, returnType, parameterType1, parameterType2);
    }

    public static <TTarget> Consumer<TTarget> instanceProcedure(Class<TTarget> targetClass, String name) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.consumer(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, new Class[0])), targetClass);
    }

    public static <TTarget> Consumer<TTarget> instanceProcedure(String targetClassName, String name) throws Throwable {
        return Reflect.instanceProcedure(Class.forName(targetClassName), name);
    }

    public static <TTarget, TIn> BiConsumer<TTarget, TIn> instanceProcedure(Class<TTarget> targetClass, String name, Class<TIn> parameterType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.consumer(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, parameterType)), targetClass, Reflect.mapLambdaParameter(parameterType));
    }

    public static <TTarget, TIn> BiConsumer<TTarget, TIn> instanceProcedure(String targetClassName, String name, Class<TIn> parameterType) throws Throwable {
        return Reflect.instanceProcedure(Class.forName(targetClassName), name, Reflect.mapLambdaParameter(parameterType));
    }

    public static <TTarget, TOut> Function<TTarget, TOut> instanceFunction(Class<TTarget> targetClass, String name, Class<TOut> returnType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.function(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, new Class[0])), returnType, targetClass);
    }

    public static <TTarget, TOut> Function<TTarget, TOut> instanceFunction(String targetClassName, String name, Class<TOut> returnType) throws Throwable {
        return Reflect.instanceFunction(Class.forName(targetClassName), name, returnType);
    }

    public static <TTarget, TIn, TOut> BiFunction<TTarget, TIn, TOut> instanceFunction(Class<TTarget> targetClass, String name, Class<TOut> returnType, Class<TIn> parameterType) throws Throwable {
        MethodHandles.Lookup lookup = LambdaFactory.lookup(targetClass);
        return LambdaFactory.function(lookup, lookup.unreflect(Reflect.getMethod(targetClass, name, parameterType)), returnType, targetClass, Reflect.mapLambdaParameter(parameterType));
    }

    public static <TTarget, TIn, TOut> BiFunction<TTarget, TIn, TOut> instanceFunction(String targetClassName, String name, Class<TOut> returnType, Class<TIn> parameterType) throws Throwable {
        return Reflect.instanceFunction(Class.forName(targetClassName), name, returnType, parameterType);
    }

    private static <T> Class<T> mapLambdaParameter(Class<T> klazz) {
        if (klazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (klazz == Byte.TYPE) {
            return Byte.class;
        }
        if (klazz == Short.TYPE) {
            return Short.class;
        }
        if (klazz == Character.TYPE) {
            return Character.class;
        }
        if (klazz == Integer.TYPE) {
            return Integer.class;
        }
        if (klazz == Long.TYPE) {
            return Long.class;
        }
        if (klazz == Float.TYPE) {
            return Float.class;
        }
        if (klazz == Double.TYPE) {
            return Double.class;
        }
        return klazz;
    }

    public static void setAccessible(Field field) throws Throwable {
        accessibleSetter.invoke(field, true);
    }
}

